DROP PROCEDURE [hips].[HealthProviderIndividualInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 2 April 2012
-- Description:   Inserts a new record into the Health Care Provider Table
-- 22/10/2012 Andrew	Changed return the data fully populated
-- =============================================

CREATE PROCEDURE [hips].[HealthProviderIndividualInsert] 
(
	@IamProviderIdentifier VARCHAR(30) = NULL,
	@HpiI VARCHAR(16) = NULL,
	@HpiILastValidatedDate DATETIME = NULL,
	@TitleId INT,
	@FamilyName VARCHAR(80),
	@GivenNames VARCHAR(100),
	@SuffixId INT,
	@UserModified VARCHAR(256)
) 
AS
BEGIN
	SET NOCOUNT ON

   DECLARE @intErrorCode int
          , @HealthProviderIndividualId INT
          
    SET @intErrorCode = 0
	INSERT INTO HealthProviderIndividual
	        ( IamProviderIdentifier ,
	          HpiI ,
	          HpiILastValidatedDate ,
	          TitleId ,
	          FamilyName ,
	          GivenNames ,
	          SuffixId ,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	        )
	VALUES  ( @IamProviderIdentifier ,
	          @HpiI , 
	          @HpiILastValidatedDate , 
	          @TitleId ,
	          @FamilyName , 
	          @GivenNames , 
	          @SuffixId , 
	          GETDATE() , 
	          @UserModified , 
	          GETDATE() , 
	          @UserModified  
	        )
	        
	 SELECT @intErrorCode = @@ERROR , @HealthProviderIndividualId = SCOPE_IdENTITY()
    IF @intErrorCode = 0
    BEGIN
	SELECT
		hcp.HealthProviderIndividualId,
		hcp.IamProviderIdentifier,
		hcp.HpiI,
		hcp.HpiILastValidatedDate,
		
		hcp.TitleId,
		t.Description AS Title,
		
		hcp.FamilyName,
		hcp.GivenNames,
		
		hcp.SuffixId,
		s.Description AS Suffix,
		hcp.DateCreated,
		hcp.UserCreated,
		hcp.DateModified,
		hcp.UserModified
		
	FROM hips.HealthProviderIndividual AS hcp 
	LEFT OUTER JOIN hips.Title AS t ON t.TitleId = hcp.TitleId
	LEFT OUTER JOIN hips.Suffix AS s ON s.SuffixId = hcp.SuffixId
	WHERE @HealthProviderIndividualId = hcp.HealthProviderIndividualId

    END

    RETURN(@intErrorCode)

	

END
GO

